/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.SmtpClientEvent;
import apiipc.generated.events.SmtpClientEventListener;
import apiipc.generated.sim.SmtpClient;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmtpClientEventRegistry
extends IPCEventRegistry {
    protected Set<SmtpClientEventListener> globalListeners = new HashSet<SmtpClientEventListener>();
    protected Map<String, Set<SmtpClientEventListener>> specificObjectListeners = new HashMap<String, Set<SmtpClientEventListener>>();

    public SmtpClientEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "SmtpClient";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        SmtpClientEvent.MailSent mailSent = null;
        if (!string.equalsIgnoreCase("mailSent")) {
            return;
        }
        mailSent = new SmtpClientEvent.MailSent(iPCEventLTV);
        for (SmtpClientEventListener object : this.globalListeners) {
            object.handleEvent(mailSent);
        }
        Set<SmtpClientEventListener> set = this.specificObjectListeners.get(mailSent.objectUUID.toString());
        if (set != null) {
            for (SmtpClientEventListener smtpClientEventListener : set) {
                smtpClientEventListener.handleEvent(mailSent);
            }
        }
    }

    public void addListenerFiltered(SmtpClientEventListener smtpClientEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("mailSent");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(smtpClientEventListener);
    }

    public void addSpecificListenerFiltered(SmtpClientEventListener smtpClientEventListener, SmtpClient smtpClient, List<String> list) throws IOException {
        UUID uUID = smtpClient.getObjectUUID();
        String string = uUID.toString();
        Set<SmtpClientEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<SmtpClientEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "mailSent");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(smtpClientEventListener);
    }

    public void removeListenerFiltered(SmtpClientEventListener smtpClientEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("mailSent");
            }
            this.globalListeners.remove(smtpClientEventListener);
        }
    }

    public void removeSpecificListenerFiltered(SmtpClientEventListener smtpClientEventListener, SmtpClient smtpClient, List<String> list) throws IOException {
        UUID uUID = smtpClient.getObjectUUID();
        String string = uUID.toString();
        Set<SmtpClientEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "mailSent");
            set.remove(smtpClientEventListener);
        }
    }

    public void addListener(SmtpClientEventListener smtpClientEventListener) throws IOException {
        this.addListenerFiltered(smtpClientEventListener, null);
    }

    public void addListener(SmtpClientEventListener smtpClientEventListener, SmtpClient smtpClient) throws IOException {
        this.addSpecificListenerFiltered(smtpClientEventListener, smtpClient, null);
    }

    public void removeListener(SmtpClientEventListener smtpClientEventListener) throws IOException {
        this.removeListenerFiltered(smtpClientEventListener, null);
    }

    public void removeListener(SmtpClientEventListener smtpClientEventListener, SmtpClient smtpClient) throws IOException {
        this.removeSpecificListenerFiltered(smtpClientEventListener, smtpClient, null);
    }
}

